#pragma once

#include "replica.h"

#include <util/generic/cast.h>
#include <unordered_map>

namespace NSolomon::NDataProxy {

template <typename T>
class TReplicaMap {
public:
    TReplicaMap() requires(!std::is_scalar_v<T>) = default;

    TReplicaMap(T initialValue = {}) noexcept requires(std::is_scalar_v<T>) {
        Values_.fill(initialValue);
    }

    T& operator[](EReplica r) noexcept {
        return Values_[Idx(r)];
    }

    const T& operator[](EReplica r) const noexcept {
        return Values_[Idx(r)];
    }

    T MaxValue() const noexcept {
        static_assert(std::size(KnownReplicas) == 2, "make sure to fix underlying code");
        return Max<T>(Values_[Idx(EReplica::R0)], Values_[Idx(EReplica::R1)]);
    }

    size_t Hash() const noexcept {
        static_assert(std::size(KnownReplicas) == 2, "make sure to fix underlying code");
        return CombineHashes(Values_[Idx(EReplica::R0)].Hash(), Values_[Idx(EReplica::R1)].Hash());
    }

    bool operator==(const TReplicaMap<T>& rhs) const noexcept {
        return Values_ == rhs.Values_;
    }

private:
    constexpr static size_t Idx(EReplica r) noexcept {
        return ToUnderlying(r) - 1u;
    }

private:
    std::array<T, std::size(KnownReplicas)> Values_;
};

} // namespace NSolomon::NDataProxy
