#include <solomon/services/dataproxy/lib/cluster_id/dc.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/cast.h>

using namespace NSolomon::NDataProxy;

TEST(TDcTest, ToString) {
    ASSERT_EQ(ToString(EDc::Sas), "sas");
    ASSERT_EQ(ToString(EDc::Vla), "vla");
    ASSERT_EQ(ToString(EDc::Man), "man");
    ASSERT_EQ(ToString(EDc::Myt), "myt");
    ASSERT_EQ(ToString(EDc::Iva), "iva");
    ASSERT_EQ(ToString(EDc::Unknown), "unknown");
}

TEST(TDcTest, FromString) {
    ASSERT_EQ(FromString<EDc>("sas"), EDc::Sas);
    ASSERT_EQ(FromString<EDc>("vla"), EDc::Vla);
    ASSERT_EQ(FromString<EDc>("man"), EDc::Man);
    ASSERT_EQ(FromString<EDc>("myt"), EDc::Myt);
    ASSERT_EQ(FromString<EDc>("iva"), EDc::Iva);
    ASSERT_EQ(FromString<EDc>("sksajdlfks"), EDc::Unknown);
}

TEST(TDcTest, ToFromStr) {
    for (EDc dc: KnownDcs) {
        ASSERT_EQ(dc, DcFromStr(DcToStr(dc))) << "dc=" << dc;
    }
}
