#include <solomon/services/dataproxy/lib/cluster_id/replica_map.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NDataProxy;

TEST(TReplicaMapTest, Default) {
    TReplicaMap<int> map;

    ASSERT_EQ(map[EReplica::R0], 0);
    ASSERT_EQ(map[EReplica::R1], 0);
    ASSERT_EQ(map.MaxValue(), 0);
}

TEST(TReplicaMapTest, Fill) {
    TReplicaMap<int> map{42};

    ASSERT_EQ(map[EReplica::R0], 42);
    ASSERT_EQ(map[EReplica::R1], 42);
    ASSERT_EQ(map.MaxValue(), 42);
}

TEST(TReplicaMapTest, Update) {
    TReplicaMap<int> map;
    map[EReplica::R0] = 1;
    map[EReplica::R1] += 2;

    ASSERT_EQ(map[EReplica::R0], 1);
    ASSERT_EQ(map[EReplica::R1], 2);
    ASSERT_EQ(map.MaxValue(), 2);
}

TEST(TReplicaMapTest, NonScalarValues) {
    TReplicaMap<std::unique_ptr<int>> map;
    ASSERT_FALSE(map[EReplica::R0]);
    ASSERT_FALSE(map[EReplica::R1]);

    map[EReplica::R0] = std::make_unique<int>(10);
    map[EReplica::R1] = std::make_unique<int>(20);

    ASSERT_EQ(*map[EReplica::R0], 10);
    ASSERT_EQ(*map[EReplica::R1], 20);
}
