#include <solomon/services/dataproxy/lib/cluster_id/replica.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/cast.h>

using namespace NSolomon::NDataProxy;

TEST(TReplicaTest, ToString) {
    ASSERT_EQ(ToString(EReplica::R0), "r0");
    ASSERT_EQ(ToString(EReplica::R1), "r1");
    ASSERT_EQ(ToString(EReplica::Unknown), "unknown");
}

TEST(TReplicaTest, FromString) {
    ASSERT_EQ(FromString<EReplica>("r0"), EReplica::R0);
    ASSERT_EQ(FromString<EReplica>("r1"), EReplica::R1);
    ASSERT_EQ(FromString<EReplica>("ioiweu"), EReplica::Unknown);
}

TEST(TReplicaTest, ToFromStr) {
    for (EReplica replica: KnownReplicas) {
        ASSERT_EQ(replica, ReplicaFromStr(ReplicaToStr(replica))) << "replica=" << replica;
    }
}
