#include "cluster_map.h"

#include <solomon/services/dataproxy/config/cluster_config.pb.h>

#include <util/generic/yexception.h>

namespace NSolomon::NDataProxy {
namespace {

void AppendDc(EReplica replica, EDc dc, const TDataCenterConfig& config, TStringMap<TClusterId>* map) {
    for (const TString& address: config.addresses()) {
        TClusterId clusterId{dc, replica};
        auto [_, isUniq] = map->emplace(address, clusterId);
        Y_ENSURE(isUniq, "non unique address '" << address << "' in cluster " << clusterId << " mapping");
    }
}

void AppendReplica(EReplica replica, const TReplicaConfig& config, TStringMap<TClusterId>* map) {
    if (config.HasSas()) {
        AppendDc(replica, EDc::Sas, config.GetSas(), map);
    }
    if (config.HasVla()) {
        AppendDc(replica, EDc::Vla, config.GetVla(), map);
    }
    if (config.HasMan()) {
        AppendDc(replica, EDc::Man, config.GetMan(), map);
    }
    if (config.HasMyt()) {
        AppendDc(replica, EDc::Myt, config.GetMyt(), map);
    }
    if (config.HasIva()) {
        AppendDc(replica, EDc::Iva, config.GetIva(), map);
    }
}

} // namespace

TClusterMap::TClusterMap(const TClusterMapConfig& config) {
    if (config.HasR0()) {
        AppendReplica(EReplica::R0, config.GetR0(), &ClusterIdByFqdn_);
    }
    if (config.HasR1()) {
        AppendReplica(EReplica::R1, config.GetR1(), &ClusterIdByFqdn_);
    }
}

} // namespace NSolomon::NDataProxy
