#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>

#include <solomon/libs/cpp/string_map/string_map.h>

namespace NSolomon::NDataProxy {

class TClusterMapConfig;

/**
 * Holds mapping from FQDN to cluster ID, which allows to determine whether
 * a host belongs to a specific cluster.
 */
class TClusterMap {
public:
    explicit TClusterMap(const TClusterMapConfig& config);

    std::optional<TClusterId> operator[](TStringBuf address) const noexcept {
        TStringBuf fqdn = address.Before(':'); // remove port
        auto it = ClusterIdByFqdn_.find(fqdn);
        return it == ClusterIdByFqdn_.end() ? std::nullopt : std::make_optional(it->second);
    }

    size_t Size() const noexcept {
        return ClusterIdByFqdn_.size();
    }

private:
    TStringMap<TClusterId> ClusterIdByFqdn_;
};

} // namespace NSolomon::NDataProxy
