#include <solomon/services/dataproxy/config/cluster_config.pb.h>
#include <solomon/services/dataproxy/lib/cluster_map/cluster_map.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NDataProxy;

TEST(TClusterMapTest, Smoke) {
    TClusterMapConfig config;

    auto* sas = config.MutableR0()->MutableSas();
    sas->AddAddresses("fetcher-sas-00");
    sas->AddAddresses("fetcher-sas-01");
    sas->AddAddresses("memstore-sas-00");
    sas->AddAddresses("memstore-sas-01");

    auto* vla = config.MutableR1()->MutableVla();
    vla->AddAddresses("fetcher-vla-00");
    vla->AddAddresses("fetcher-vla-01");
    vla->AddAddresses("memstore-vla-00");
    vla->AddAddresses("memstore-vla-01");

    TClusterMap map(config);
    ASSERT_EQ(map.Size(), 8u);
    EXPECT_EQ(map["fetcher-vla-00"], TClusterId(EDc::Vla, EReplica::R1));
    EXPECT_EQ(map["memstore-vla-01"], TClusterId(EDc::Vla, EReplica::R1));
    EXPECT_EQ(map["fetcher-sas-01"], TClusterId(EDc::Sas, EReplica::R0));
    EXPECT_EQ(map["memstore-sas-00"], TClusterId(EDc::Sas, EReplica::R0));
}

TEST(TClusterMapTest, DuplicateHost) {
    TClusterMapConfig config;

    auto* sas = config.MutableR0()->MutableSas();
    sas->AddAddresses("fetcher-sas-00");
    sas->AddAddresses("fetcher-sas-01");

    auto* vla = config.MutableR1()->MutableVla();
    vla->AddAddresses("fetcher-vla-00");
    vla->AddAddresses("fetcher-vla-01");
    vla->AddAddresses("fetcher-sas-00"); // added by mistake

    EXPECT_THROW_MESSAGE_HAS_SUBSTR({
          TClusterMap map(config);
    }, yexception, "non unique address 'fetcher-sas-00' in cluster vla-r1 mapping");
}
