#include <solomon/services/dataproxy/lib/config/config.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/system/tempfile.h>

using namespace NSolomon::NDataProxy;

namespace {

void ValidateResource(TStringBuf name) {
    TString configText = NResource::Find(name);
    ASSERT_FALSE(configText.Empty());

    TTempFileHandle tmp;
    tmp.Write(configText.data(), configText.size());
    tmp.FlushData();

    TDataProxyConfig config = ParseTextProto(tmp.Name());
    ASSERT_NO_THROW({ Validate(config); });
}

} // namespace

TEST(TConfigTest, DevConfValid) {
    ValidateResource("dev/dataproxy.conf");
}

TEST(TConfigTest, TestingConfValid) {
    ValidateResource("testing/dataproxy.conf");
}

TEST(TConfigTest, PrestableConfValid) {
    ValidateResource("prestable/dataproxy.conf");
}

TEST(TConfigTest, ProdConfValid) {
    ValidateResource("production/dataproxy.conf");
}
