#include "out.h"

#include <library/cpp/monlib/metrics/histogram_snapshot.h>

namespace NSolomon::NDataProxy {

namespace {

TStringBuilder& operator<<(TStringBuilder& out, const NTs::NValue::THistogram& hist) {
    out << "{";
    for (size_t i = 0; i < hist.Buckets.size(); ++i) {
        if (hist.Buckets[i].UpperBound == NMonitoring::HISTOGRAM_INF_BOUND) {
            out << "inf";
        } else {
            out << hist.Buckets[i].UpperBound;
        }

        out << ": " << hist.Buckets[i].Value;

        if (i + 1 != hist.Buckets.size()) {
            out << ", ";
        }
    }
    out << "}";

    return out;
}

TStringBuilder& operator<<(TStringBuilder& out, const NTs::NValue::TLogHistogram& hist) {
    out << "{zeros: " << hist.ZeroCount << ", startPower: " << hist.StartPower << ", values: [";
    for (size_t i = 0; i < hist.Values.size(); ++i) {
        out << hist.Values[i];
        if (i + 1 != hist.Values.size()) {
            out << ", ";
        }
    }
    out << "]}";

    return out;
}

template <typename T>
TStringBuilder& operator<<(TStringBuilder& out, const NTs::NValue::TSummary<T>& s) {
    out << "{"
        << "sum: " << s.Sum << ", min: " << s.Min << ", max: " << s.Max << ", last: " << s.Last
        << ", count: " << s.CountValue << "}";

    return out;
}

TStringBuilder& operator<<(TStringBuilder& out, const NTs::NValue::TDouble& d) {
    return out << d.Num << '/' << d.Denom;
}

TStringBuilder& operator<<(TStringBuilder& out, const NTs::NValue::TLong& l) {
    return out << l.Value;
}

} // namespace

TStringBuilder& operator<<(TStringBuilder& out, const NTs::TVariantPoint& point) {
    return std::visit([&out](auto&& value) -> TStringBuilder& {
        return out << value;
    }, point.Value);
}

} // namespace NSolomon::NDataProxy
