#pragma once

#include "query.h"
#include "result_handler.h"

#include <solomon/libs/cpp/trace/trace.h>


namespace NSolomon::NDataProxy {

/**
 * Interface for supported backends implementation.
 */
class IDataSource: public TThrRefBase {
public:
    /**
     * Cheсks that data source implementation can process the given query.
     *
     * @param query  query which will be processed
     * @return true if data source can process query, false - otherwise
     */
    virtual bool CanHandle(const TQuery& query) const = 0;

    virtual void Find(TFindQuery query, IResultHandlerPtr<TFindResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void ResolveOne(TResolveOneQuery query, IResultHandlerPtr<TResolveOneResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void ResolveMany(TResolveManyQuery query, IResultHandlerPtr<TResolveManyResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void MetricNames(TMetricNamesQuery query, IResultHandlerPtr<TMetricNamesResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void LabelKeys(TLabelKeysQuery query, IResultHandlerPtr<TLabelKeysResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void LabelValues(TLabelValuesQuery query, IResultHandlerPtr<TLabelValuesResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void UniqueLabels(TUniqueLabelsQuery query, IResultHandlerPtr<TUniqueLabelsResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void ReadOne(TReadOneQuery query, IResultHandlerPtr<TReadOneResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void ReadMany(TReadManyQuery query, IResultHandlerPtr<TReadManyResult> handler, ::NSolomon::NTracing::TSpanId traceCtx = {}) const = 0;

    virtual void WaitUntilInitialized() const = 0;
};

using IDataSourcePtr = TIntrusivePtr<IDataSource>;

} // namespace NSolomon::NDataProxy
