#pragma once

#include "replica.h"

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/result_handler.h>

#include <solomon/libs/cpp/trace/trace.h>

#include <solomon/libs/cpp/actors/fwd.h>

namespace NSolomon::NDataProxy {

std::unique_ptr<NActors::IActor> ReadOneActor(
        const TLtsReplicas& replicas,
        TReadOneQuery query,
        IResultHandlerPtr<TReadOneResult> handler,
        NTracing::TSpanId traceCtx);

std::unique_ptr<NActors::IActor> ReadManyActor(
        const TLtsReplicas& replicas,
        TReadManyQuery query,
        IResultHandlerPtr<TReadManyResult> handler,
        NTracing::TSpanId traceCtx);

} // namespace NSolomon::NDataProxy
