#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class FindRequest;
class FindResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TFindMarshaller {
public:
    using TQuery = TFindQuery;
    using TResult = TFindResult;

private:
    struct TMetricState {
        NMonitoring::EMetricType Type;
        TReplicaMap<TStockpileId> StockpileIds;
    };

public:
    TFindMarshaller(TFindQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::FindRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::FindResponse& resp);

    std::unique_ptr<TFindResult> MakeResult();

private:
    TFindQuery Query_;
    TReplicaMap<EDc> Dcs_{EDc::Unknown};
    std::unordered_map<TMetricKey<ui32>, TMetricState> Metrics_;
    NStringPool::TStringPoolBuilder Strings_;
    ui32 TotalCount_{0};
};

} // namespace NSolomon::NDataProxy
