#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class TLabelNamesRequest;
class TLabelNamesResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TLabelKeysMarshaller {
public:
    using TQuery = TLabelKeysQuery;
    using TResult = TLabelKeysResult;

public:
    TLabelKeysMarshaller(TLabelKeysQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::TLabelNamesRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::TLabelNamesResponse& resp);

    std::unique_ptr<TLabelKeysResult> MakeResult();

private:
    void AddKey(TStringBuf key);

private:
    TLabelKeysQuery Query_;
    NStringPool::TStringPoolBuilder Strings_;
    TVector<ui32> Keys_;
    i32 LastKeyId_{-1};
};

} // namespace NSolomon::NDataProxy
