#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class TLabelValuesRequest;
class TLabelValuesResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TLabelValuesMarshaller {
public:
    using TQuery = TLabelValuesQuery;
    using TResult = TLabelValuesResult;

public:
    TLabelValuesMarshaller(TLabelValuesQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::TLabelValuesRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::TLabelValuesResponse& resp);

    std::unique_ptr<TLabelValuesResult> MakeResult();

private:
    struct TLabelState {
        std::unordered_set<ui32> Values;
        ui32 MetricCount{0};
        bool Truncated{false};
    };

    TLabelValuesQuery Query_;
    NStringPool::TStringPoolBuilder Strings_;
    std::unordered_map<ui32, TLabelState> Labels_; // label key -> label info
    TReplicaMap<ui32> MetricCounts_{0};
};

} // namespace NSolomon::NDataProxy
