#include "metric_names_marshaller.h"
#include "marshaller_helpers.h"

#include <solomon/libs/cpp/proto_convert/metric_type.h>
#include <solomon/protos/metabase/grpc_metric_names.pb.h>

namespace NSolomon::NDataProxy {

using yandex::solomon::metabase::MetricNamesRequest;
using yandex::solomon::metabase::MetricNamesResponse;

TMetricNamesMarshaller::TMetricNamesMarshaller(TMetricNamesQuery query) noexcept
    : Query_(std::move(query))
{
}

TShardSelector TMetricNamesMarshaller::ShardSelector() const {
    return TShardSelector::FromSelectors(Query_.Project, Query_.Selectors);
}

void TMetricNamesMarshaller::FillRequest(MetricNamesRequest* req) const {
    SelectorsToProto(Query_.Project, Query_.Selectors, req->mutable_selectors()->mutable_label_selectors());
    req->set_textsearch(Query_.TextFilter);
    req->set_limit(Query_.Limit);
    req->set_deadlinemillis(Query_.Deadline.MilliSeconds());
}

void TMetricNamesMarshaller::AddResponse(EReplica, EDc, const MetricNamesResponse& resp) {
    if (Names_.empty()) {
        Names_.reserve(resp.names_size());
    }

    for (const auto& name: resp.names()) {
        if (Names_.size() >= Query_.Limit) {
            break;
        }

        ui32 nameId = Strings_.Put(name);

        // because of NStringPool::TStringPoolBuilder uses monotonically incremented ids
        // this is cheapest way to avoid names duplication
        if (static_cast<i32>(nameId) > LastNameId_) {
            LastNameId_ = static_cast<i32>(nameId);
            Names_.push_back(nameId);
        }
    }

    Truncated_ = Truncated_ | resp.truncated();
}

std::unique_ptr<TMetricNamesResult> TMetricNamesMarshaller::MakeResult() {
    auto result = std::make_unique<TMetricNamesResult>();
    result->Strings = std::move(Strings_);
    result->Names = std::move(Names_);
    result->TotalCount = 0; // TODO: support in metabase
    result->Truncated = Truncated_;
    return result;
}

} // namespace NSolomon::NDataProxy
