#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class MetricNamesRequest;
class MetricNamesResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TMetricNamesMarshaller {
public:
    using TQuery = TMetricNamesQuery;
    using TResult = TMetricNamesResult;

public:
    TMetricNamesMarshaller(TMetricNamesQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::MetricNamesRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::MetricNamesResponse& resp);

    std::unique_ptr<TMetricNamesResult> MakeResult();

private:
    TMetricNamesQuery Query_;
    NStringPool::TStringPoolBuilder Strings_;
    TVector<ui32> Names_;
    i32 LastNameId_{-1};
    bool Truncated_{false};
};

} // namespace NSolomon::NDataProxy
