#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>
#include <solomon/services/dataproxy/lib/cluster_id/replica_map.h>

#include <library/cpp/actors/core/actorid.h>

#include <optional>

namespace NSolomon::NDataProxy {

struct TLtsReplica {
    TClusterId ClusterId{EDc::Unknown, EReplica::Unknown};
    NActors::TActorId MetabaseClusterId;
    NActors::TActorId StockpileClusterId;

    TStringBuf Name() const noexcept {
        // TODO: do not use dc as replica name
        return DcToStr(ClusterId.Dc());
    }

    EDc Dc() const noexcept {
        return ClusterId.Dc();
    }
};

using TLtsReplicas = TReplicaMap<std::optional<TLtsReplica>>;

} // namespace NSolomon::NDataProxy
