#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class ResolveManyRequest;
class ResolveManyResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TResolveManyMarshaller {
public:
    using TQuery = TResolveManyQuery;
    using TResult = TResolveManyResult;

private:
    struct TMetricState {
        NMonitoring::EMetricType Type;
        TReplicaMap<TStockpileId> StockpileIds;
    };

public:
    TResolveManyMarshaller(TResolveManyQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::ResolveManyRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::ResolveManyResponse& resp);

    std::unique_ptr<TResolveManyResult> MakeResult();

private:
    TResolveManyQuery Query_;
    std::unordered_map<TMetricKey<ui32>, TMetricState> Metrics_;
    NStringPool::TStringPoolBuilder Strings_;
    TReplicaMap<EDc> Dcs_;
};

} // namespace NSolomon::NDataProxy
