#include "resolve_one_marshaller.h"
#include "marshaller_helpers.h"

#include <solomon/libs/cpp/proto_convert/metric_type.h>
#include <solomon/protos/metabase/grpc_resolve.pb.h>

namespace NSolomon::NDataProxy {

using yandex::solomon::metabase::ResolveOneRequest;
using yandex::solomon::metabase::ResolveOneResponse;

TResolveOneMarshaller::TResolveOneMarshaller(TResolveOneQuery query) noexcept
    : Query_(std::move(query))
{
}

TShardSelector TResolveOneMarshaller::ShardSelector() const {
    return TShardSelector::FromLabels(Query_.Project, Query_.Key.Labels);
}

void TResolveOneMarshaller::FillRequest(ResolveOneRequest* req) const {
    const auto& metricKey = Query_.Key;
    req->SetName(metricKey.Name);
    LabelsToProto(metricKey.Labels, req->mutable_labels());
    req->SetDeadlineMillis(Query_.Deadline.MilliSeconds());
}

void TResolveOneMarshaller::AddResponse(EReplica replica, EDc dc, const ResolveOneResponse& resp) {
    Dcs_[replica] = dc;
    auto& metric = resp.metric();
    Metric_.Type = NSolomon::FromProto(metric.type());
    Metric_.Name = metric.name();

    Metric_.Labels.clear();
    LabelsFromProto(metric.labels(), &Metric_.Labels);

    TStockpileId& stockpileId = Metric_.StockpileIds[replica];
    stockpileId.ShardId = metric.metric_id().shard_id();
    stockpileId.LocalId = metric.metric_id().local_id();
}

std::unique_ptr<TResolveOneResult> TResolveOneMarshaller::MakeResult() {
    auto result = std::make_unique<TResolveOneResult>();
    result->Metric = std::move(Metric_);
    result->Dcs = Dcs_;
    return result;
}

} // namespace NSolomon::NDataProxy
