#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class ResolveOneRequest;
class ResolveOneResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TResolveOneMarshaller {
public:
    using TQuery = TResolveOneQuery;
    using TResult = TResolveOneResult;

public:
    TResolveOneMarshaller(TResolveOneQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::ResolveOneRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::ResolveOneResponse& resp);

    std::unique_ptr<TResolveOneResult> MakeResult();

private:
    TResolveOneQuery Query_;
    TMetric<TString> Metric_;
    TReplicaMap<EDc> Dcs_;
};

} // namespace NSolomon::NDataProxy
