#include "unique_labels_marshaller.h"
#include "marshaller_helpers.h"

#include <solomon/libs/cpp/proto_convert/metric_type.h>
#include <solomon/protos/metabase/grpc_label_unique.pb.h>

namespace NSolomon::NDataProxy {

using yandex::solomon::metabase::TUniqueLabelsRequest;
using yandex::solomon::metabase::TUniqueLabelsResponse;

TUniqueLabelsMarshaller::TUniqueLabelsMarshaller(TUniqueLabelsQuery query) noexcept
    : Query_(std::move(query))
{
}

TShardSelector TUniqueLabelsMarshaller::ShardSelector() const {
    return TShardSelector::FromSelectors(Query_.Project, Query_.Selectors);
}

void TUniqueLabelsMarshaller::FillRequest(TUniqueLabelsRequest* req) const {
    SelectorsToProto(Query_.Project, Query_.Selectors, req->mutable_selectors());
    for (const auto& key: Query_.Keys) {
        req->add_names(key);
    }
    req->set_deadlinemillis(Query_.Deadline.MilliSeconds());
}

void TUniqueLabelsMarshaller::AddResponse(EReplica, EDc, const TUniqueLabelsResponse& resp) {
    if (Labels_.empty()) {
        Labels_.reserve(resp.labellists_size());
    }

    for (const auto& labelsProto: resp.labellists()) {
        TLabels<ui32> labels;
        LabelsFromProto(labelsProto.labels(), &Strings_, &labels);
        Labels_.emplace(std::move(labels));
    }
}

std::unique_ptr<TUniqueLabelsResult> TUniqueLabelsMarshaller::MakeResult() {
    auto result = std::make_unique<TUniqueLabelsResult>();
    result->Strings = std::move(Strings_);
    result->Labels.reserve(Labels_.size());
    std::move(std::begin(Labels_), std::end(Labels_), std::back_inserter(result->Labels));
    return result;
}

} // namespace NSolomon::NDataProxy
