#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace yandex::solomon::metabase {
class TUniqueLabelsRequest;
class TUniqueLabelsResponse;
} // namespace yandex::solomon::metabase

namespace NSolomon::NDataProxy {

struct TShardSelector;

class TUniqueLabelsMarshaller {
public:
    using TQuery = TUniqueLabelsQuery;
    using TResult = TUniqueLabelsResult;

public:
    TUniqueLabelsMarshaller(TUniqueLabelsQuery query) noexcept;

    TShardSelector ShardSelector() const;

    void FillRequest(yandex::solomon::metabase::TUniqueLabelsRequest* req) const;
    void AddResponse(EReplica replica, EDc dc, const yandex::solomon::metabase::TUniqueLabelsResponse& resp);

    std::unique_ptr<TUniqueLabelsResult> MakeResult();

private:
    TUniqueLabelsQuery Query_;
    NStringPool::TStringPoolBuilder Strings_;
    std::unordered_set<TLabels<ui32>> Labels_;
};

} // namespace NSolomon::NDataProxy
