#pragma once

#include <util/generic/string.h>

#include <google/protobuf/text_format.h>

namespace NSolomon::NDataProxy {

template <typename T>
T ParseResp(const TString& data) {
    T value;
    Y_ENSURE(::google::protobuf::TextFormat::ParseFromString(data, &value));
    return value;
}

} // namespace NSolomon::NDataProxy
