#include "selector_asserts.h"

namespace NSolomon::NDataProxy {

using namespace yandex::solomon::model;

::testing::AssertionResult LabelEq(const Label& l, TStringBuf key, TStringBuf value) {
    if (l.key() != key) {
        return ::testing::AssertionFailure()
                << "label has different key, "
                << "expected " << key
                << ", but was " << l.key();
    }

    if (l.value() != value) {
        return ::testing::AssertionFailure()
                << "label has different value, "
                << "expected " << value
                << ", but was " << l.value();
    }

    return ::testing::AssertionSuccess();
}

::testing::AssertionResult SelectorEq(const Selector& s, MatchType matchType, TStringBuf key, TStringBuf pattern) {
    if (s.match_type() != matchType) {
        return ::testing::AssertionFailure()
                << "selector has different match type, "
                << "expected " << MatchType_Name(matchType)
                << ", but was " << MatchType_Name(s.match_type());
    }

    if (s.key() != key) {
        return ::testing::AssertionFailure()
                << "selector has different key, "
                << "expected " << key
                << ", but was " << s.key();
    }

    if (s.pattern() != pattern) {
        return ::testing::AssertionFailure()
                << "selector has different pattern, "
                << "expected " << pattern
                << ", but was " << s.pattern();
    }

    return ::testing::AssertionSuccess();
}

} // namespace NSolomon::NDataProxy
