#pragma once

#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/storage_type.h>
#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/limits.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

namespace NSolomon::NDataProxy::NMerger {

class TFindMerger {
public:
    explicit TFindMerger(size_t metricsLimit);

    void AddResponse(TFindResult&& response, EStorageType type);
    void AddError(TDataSourceError error);

    std::unique_ptr<TFindResult> Finish();

private:
    struct TMetricValue {
        using TID = TReplicaMap<TStockpileId>;

        NMonitoring::EMetricType Type;
        TID LtsId{};
    };

    size_t MetricsLimit_;

    absl::flat_hash_map<TMetricKey<ui32>, TMetricValue> Metrics_;
    NStringPool::TStringPoolBuilder Strings_;

    TDataSourceErrors Errors_;

    ui32 STSTotalCount_ = 0;
    ui32 LTSTotalCount_ = 0;
    bool Truncated_ = false;

    TReplicaMap<EDc> LTSDcs_{EDc::Unknown};
};

} // NSolomon::NDataProxy::NMerger
