#include "merger.h"

namespace NSolomon::NDataProxy::NMerger {

void TLabelKeysMerger::AddResponse(TLabelKeysResult&& res, EStorageType) {
    Keys_.reserve(res.Keys.size());
    auto resStrings = res.Strings.Build();

    for (auto key: res.Keys) {
        ui32 k = Strings_.Put(resStrings[key]);
        if (Keys_.empty() || k > Keys_.back()) {
            Keys_.emplace_back(k);
        }
    }

    Errors_.insert(Errors_.end(), res.Errors.begin(), res.Errors.end());
}

void TLabelKeysMerger::AddError(TDataSourceError error) {
    Errors_.emplace_back(std::move(error));
}

std::unique_ptr<TLabelKeysResult> TLabelKeysMerger::Finish() {
    auto res = std::make_unique<TLabelKeysResult>();

    res->Strings = std::move(Strings_);
    res->Keys = std::move(Keys_);
    res->Errors = std::move(Errors_);

    return res;
}

} // namespace NSolomon::NDataProxy::NMerger
