#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/storage_type.h>

#include <solomon/libs/cpp/string_pool/string_pool.h>

#include <util/generic/vector.h>

#include <array>

namespace NSolomon::NDataProxy::NMerger {

class TLabelKeysMerger {
public:
    void AddResponse(TLabelKeysResult&& res, EStorageType);

    std::unique_ptr<TLabelKeysResult> Finish();
    void AddError(TDataSourceError error);

private:
    NStringPool::TStringPoolBuilder Strings_;
    TVector<ui32> Keys_;
    TDataSourceErrors Errors_;
};

} // namespace NSolomon::NDataProxy::NMerger
