#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/label_keys/merger.h>

#include <solomon/libs/cpp/string_pool/string_pool.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/builder.h>

#include <algorithm>

using namespace NSolomon;
using namespace NDataProxy;
using namespace NMonitoring;
using namespace NMerger;

TLabelKeysResult MakeResult(const TVector<TString>& keys) {
    NStringPool::TStringPoolBuilder sb;
    TLabelKeysResult res;

    for (const auto& key: keys) {
        res.Keys.emplace_back(sb.Put(key));
    }

    res.Strings = std::move(sb);
    return res;
}

TEST(TLabelKeysMerger, Common) {
    TLabelKeysMerger merger;

    TVector<TString> stsStrings{"fetcher", "ingestor", "memstore"};
    TVector<TString> ltsStrings{"ingestor", "memstore", "dumper"};

    merger.AddResponse(MakeResult(stsStrings), EStorageType::STS);
    merger.AddResponse(MakeResult(ltsStrings), EStorageType::LTS);

    auto res = merger.Finish();

    EXPECT_EQ(res->Strings.Size(), 4u);
    ASSERT_EQ(res->Keys.size(), 4u);

    TVector<TString> all{"dumper", "fetcher", "ingestor", "memstore"};
    auto strings = res->Strings.Build();

    std::sort(res->Keys.begin(), res->Keys.end(), [&strings](ui32 lhs, ui32 rhs) {
        return strings[lhs] < strings[rhs];
    });

    for (size_t i = 0; i < all.size(); ++i) {
        EXPECT_EQ(all[i], strings[res->Keys[i]]);
    }
}
