#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/storage_type.h>

#include <solomon/libs/cpp/string_pool/string_pool.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>
#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

namespace NSolomon::NDataProxy::NMerger {

class TLabelValuesMerger {
public:
    explicit TLabelValuesMerger(ui32 valuesLimit);

    void AddResponse(TLabelValuesResult&& res, EStorageType type);
    void AddError(TDataSourceError error);

    std::unique_ptr<TLabelValuesResult> Finish();

private:
    struct TState {
        absl::flat_hash_set<ui32> Values;
        std::array<ui32, ToUnderlying(EStorageType::COUNT)> TotalCount{0, 0};
        bool Truncated = false;
    };

    ui32 ValuesLimit_;
    absl::flat_hash_map<ui32, TState> State_;
    NStringPool::TStringPoolBuilder Strings_;
    std::array<ui32, ToUnderlying(EStorageType::COUNT)> MetricCount_{0, 0};
    TDataSourceErrors Errors_;
    TString Project_;
};

} // namespace NSolomon::NDataProxy::NMerger
