#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/storage_type.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

namespace NSolomon::NDataProxy::NMerger {

class TReadManyMerger {
public:
    explicit TReadManyMerger(size_t metricsLimit);

    std::unique_ptr<TReadManyResult> Finish();

    void AddResponse(TReadManyResult&& response, EStorageType type);

    void AddError(TDataSourceError error);

private:
    size_t MetricsLimit_;

    struct TMetricValue {
        std::array<std::unique_ptr<ITimeSeries>, ToUnderlying(EStorageType::COUNT)> Timeseries;
    };

    std::unique_ptr<ITimeSeries> Merge(
            std::array<std::unique_ptr<ITimeSeries>, ToUnderlying(EStorageType::COUNT)>&& data);

    absl::flat_hash_map<TMetricKey<ui32>, TMetricValue> Metrics_;
    NStringPool::TStringPoolBuilder Strings_;
    TDataSourceErrors Errors_;
};

} // namespace NSolomon::NDataProxy::NMerger
