#include "merger.h"

namespace NSolomon::NDataProxy::NMerger {

void TUniqueLabelsMerger::AddResponse(TUniqueLabelsResult&& res, EStorageType) {
    auto resStrings = res.Strings.Build();

    for (auto&& labels: res.Labels) {
        for (auto& [name, value]: labels) {
            name = Strings_.Put(resStrings[name]);
            value = Strings_.Put(resStrings[value]);
        }

        std::sort(labels.begin(), labels.end(), [](auto lhs, auto rhs) {
            return lhs.Key < rhs.Key;
        });

        Labels_.emplace(std::move(labels));
    }

    Errors_.insert(Errors_.end(), res.Errors.begin(), res.Errors.end());
}

std::unique_ptr<TUniqueLabelsResult> TUniqueLabelsMerger::Finish() {
    auto res = std::make_unique<TUniqueLabelsResult>();
    res->Labels.reserve(Labels_.size());

    for (auto it = Labels_.begin(); it != Labels_.end(); ) {
        auto node = Labels_.extract(it++);

        res->Labels.emplace_back(std::move(node.value()));
    }

    res->Strings = std::move(Strings_);
    res->Errors = std::move(Errors_);

    return res;
}

void TUniqueLabelsMerger::AddError(TDataSourceError error) {
    Errors_.emplace_back(std::move(error));
}

} // namespace NSolomon::NDataProxy::NMerger
