#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/storage_type.h>

#include <solomon/libs/cpp/string_pool/string_pool.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

namespace NSolomon::NDataProxy::NMerger {

class TUniqueLabelsMerger {
public:
    void AddResponse(TUniqueLabelsResult&& res, EStorageType);
    void AddError(TDataSourceError error);

    std::unique_ptr<TUniqueLabelsResult> Finish();

private:
    NStringPool::TStringPoolBuilder Strings_;
    absl::flat_hash_set<TLabels<ui32>> Labels_;
    TDataSourceErrors Errors_;
};

} // namespace NSolomon::NDataProxy::NMerger
