#include <solomon/services/dataproxy/lib/datasource/merge_sts_lts/unique_labels/merger.h>

#include <solomon/libs/cpp/string_pool/string_pool.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/builder.h>

using namespace NSolomon;
using namespace NDataProxy;
using namespace NMonitoring;
using namespace NMerger;

TLabels<ui32> MakeLabels(const TVector<std::pair<const char*, const char*>>& labels, NStringPool::TStringPoolBuilder& sb) {
    TLabels<ui32> res;
    for (const auto& label: labels) {
        ui32 k = sb.Put(label.first);
        ui32 v = sb.Put(label.second);
        res.emplace_back(k, v);
    }

    return res;
}

TEST(TLabelKeysMerger, Common) {
    TUniqueLabelsMerger merger;

    TUniqueLabelsResult stsRes;
    TUniqueLabelsResult ltsRes;

    {
        NStringPool::TStringPoolBuilder sb;
        stsRes.Labels.emplace_back(MakeLabels({{"sensor", "cpu_usage"}, {"service", "fetcher"}}, sb));
        stsRes.Labels.emplace_back(MakeLabels({{"sensor", "memory_usage"}, {"service", "fetcher"}}, sb));

        stsRes.Strings = std::move(sb);
    }

    {
        NStringPool::TStringPoolBuilder sb;
        ltsRes.Labels.emplace_back(MakeLabels({{"sensor", "memory_usage"}, {"service", "fetcher"}}, sb));
        ltsRes.Labels.emplace_back(MakeLabels({{"sensor", "disk_usage"}, {"service", "fetcher"}}, sb));

        ltsRes.Strings = std::move(sb);
    }

    merger.AddResponse(std::move(stsRes), EStorageType::STS);
    merger.AddResponse(std::move(ltsRes), EStorageType::LTS);

    auto res = merger.Finish();

    EXPECT_EQ(res->Strings.Size(), 6u);
    ASSERT_EQ(res->Labels.size(), 3u);

    auto resStrings = res->Strings.Build();

    std::sort(res->Labels.begin(), res->Labels.end(), [&resStrings](const auto& lhs, const auto& rhs) {
        return resStrings[lhs[0].Value] < resStrings[rhs[0].Value];
    });

    {
        const auto& la = res->Labels[2];

        EXPECT_EQ(resStrings[la[0].Key], "sensor");
        EXPECT_EQ(resStrings[la[0].Value], "memory_usage");

        EXPECT_EQ(resStrings[la[1].Key], "service");
        EXPECT_EQ(resStrings[la[1].Value], "fetcher");
    }

    {
        const auto& la = res->Labels[0];

        EXPECT_EQ(resStrings[la[0].Key], "sensor");
        EXPECT_EQ(resStrings[la[0].Value], "cpu_usage");

        EXPECT_EQ(resStrings[la[1].Key], "service");
        EXPECT_EQ(resStrings[la[1].Value], "fetcher");
    }

    {
        const auto& la = res->Labels[1];

        EXPECT_EQ(resStrings[la[0].Key], "sensor");
        EXPECT_EQ(resStrings[la[0].Value], "disk_usage");

        EXPECT_EQ(resStrings[la[1].Key], "service");
        EXPECT_EQ(resStrings[la[1].Value], "fetcher");
    }
}
