#pragma once

#include "status_code.h"

#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NSolomon::NDataProxy {

template <typename T>
struct IResultHandler: public TThrRefBase {
    virtual void OnSuccess(std::unique_ptr<T> result) = 0;
    virtual void OnError(TString&& project, EDataSourceStatus status, TString&& message) = 0;
};

template <typename T>
using IResultHandlerPtr = TIntrusivePtr<IResultHandler<T>>;

} // namespace NSolomon::NDataProxy
