#pragma once

#include <array>

namespace NSolomon::NDataProxy {

enum class EDataSourceStatus {
    // Unknown error happened.
    UNKNOWN,

    // The request has succeeded.
    // (same as http 200)
    OK,

    // The backend cannot or will not process the request due to something that
    // is perceived to be a client error.
    // (same as http 400)
    BAD_REQUEST,

    // The backend did not find a current representation for the target resource.
    // (same as http 404)
    NOT_FOUND,

    // The backend encountered an unexpected condition that prevented it from
    // fulfilling the request.
    // (same as http 500)
    BACKEND_ERROR,

    // The backend is currently unable to handle the request due to a temporary
    // overload or maintenance.
    // (same as http 503)
    BACKEND_UNAVAILABLE,

    // The backend did not send a response in appropriate timeout.
    // (same as http 504)
    BACKEND_TIMEOUT,
};

constexpr std::array DataSourceStatuses = {
    EDataSourceStatus::UNKNOWN,
    EDataSourceStatus::OK,
    EDataSourceStatus::BAD_REQUEST,
    EDataSourceStatus::NOT_FOUND,
    EDataSourceStatus::BACKEND_ERROR,
    EDataSourceStatus::BACKEND_UNAVAILABLE,
    EDataSourceStatus::BACKEND_TIMEOUT,
};

} // namespace NSolomon::NDataProxy
