#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>
#include <solomon/services/dataproxy/lib/cluster_id/replica_map.h>
#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/shard/shard_id.h>
#include <solomon/services/dataproxy/lib/shard/shard_key.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

#include <grpc++/support/status_code_enum.h>

namespace yandex::monitoring::memstore {
class FindResponse;
} // namespace yandex::monitoring::memstore

namespace NSolomon::NDataProxy {

class TFindMerger {
public:
    explicit TFindMerger(TString project, size_t limit) noexcept
        : Project_{std::move(project)}
        , Limit_{limit}
    {
    }

    void AddResponse(
            TClusterId clusterId,
            const TShardSubKey& shardKey,
            const yandex::monitoring::memstore::FindResponse& resp);

    void AddError(TClusterId clusterId, TShardId shardId, grpc::StatusCode statusCode, TString message);

    std::unique_ptr<TFindResult> Finish();

private:
    TString Project_;
    size_t Limit_;
    absl::flat_hash_map<TMetricKey<ui32>, NMonitoring::EMetricType> Metrics_;
    NStringPool::TStringPoolBuilder Strings_;
    TDataSourceErrors Errors_;
    TReplicaMap<ui32> TotalCount_;
    TReplicaMap<bool> Truncated_;
};

} // namespace NSolomon::NDataProxy
