#include "merger.h"

#include <solomon/services/memstore/api/memstore_service.pb.h>

#include <solomon/libs/cpp/proto_convert/metric_type.h>
#include <solomon/libs/cpp/yasm/constants/labels.h>

namespace NSolomon::NDataProxy {

using yandex::monitoring::memstore::LabelKeysResponse;

void TLabelKeysMerger::AddResponse(const LabelKeysResponse& resp) {
    NStringPool::TStringPool respPool{resp.string_pool()};

    for (ui32 keyId: resp.keys_idx()) {
        if (respPool[keyId] != NYasm::AGGREGATED_MARKER) { // for viewing YASM data SOLOMON-7804
            AddKey(respPool[keyId]);
        }
    }
}

void TLabelKeysMerger::AddError(TClusterId clusterId, TShardId shardId, grpc::StatusCode statusCode, TString message) {
    Y_UNUSED(clusterId, shardId, statusCode, message);
    // TODO: aggregate per shard errors
    Errors_.emplace_back(statusCode, std::move(message));
}

std::unique_ptr<TLabelKeysResult> TLabelKeysMerger::Finish() {
    if (AddCluster_) {
        AddKey(TStringBuf(NLabels::LABEL_CLUSTER));
    }

    if (AddService_) {
        AddKey(TStringBuf(NLabels::LABEL_SERVICE));
    }

    auto result = std::make_unique<TLabelKeysResult>();
    result->Strings = std::move(Strings_);
    result->Keys = std::move(Keys_);
    result->Errors = std::move(Errors_);
    return result;
}

void TLabelKeysMerger::AddKey(TStringBuf key) {
    ui32 keyId = Strings_.Put(key);

    // because of NStringPool::TStringPoolBuilder uses monotonically incremented ids
    // this is the cheapest way to avoid strings duplication
    if (static_cast<i32>(keyId) > LastKeyId_) {
        LastKeyId_ = static_cast<i32>(keyId);
        Keys_.push_back(keyId);
    }
}

} // namespace NSolomon::NDataProxy
