#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>
#include <solomon/services/dataproxy/lib/cluster_id/replica_map.h>
#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/shard/shard_id.h>
#include <solomon/services/dataproxy/lib/shard/shard_key.h>

#include <solomon/libs/cpp/labels/known_keys.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

#include <grpc++/support/status_code_enum.h>

namespace yandex::monitoring::memstore {
class LabelKeysResponse;
} // namespace yandex::monitoring::memstore

namespace NSolomon::NDataProxy {

class TLabelKeysMerger {
public:
    explicit TLabelKeysMerger(const TSelectors& selectors, const TString& project) noexcept
        : AddCluster_{!selectors.Has(NLabels::LABEL_CLUSTER) && !NYasm::IsYasmProject(project)}
        , AddService_{!selectors.Has(NLabels::LABEL_SERVICE) && !NYasm::IsYasmProject(project)} {
    }

    void AddResponse(const yandex::monitoring::memstore::LabelKeysResponse& resp);

    void AddError(TClusterId clusterId, TShardId shardId, grpc::StatusCode statusCode, TString message);

    std::unique_ptr<TLabelKeysResult> Finish();

private:
    void AddKey(TStringBuf key);

private:
    NStringPool::TStringPoolBuilder Strings_;
    TVector<ui32> Keys_;
    TDataSourceErrors Errors_;
    i32 LastKeyId_{-1};
    bool AddCluster_;
    bool AddService_;
};

} // namespace NSolomon::NDataProxy
