#include <solomon/services/dataproxy/lib/datasource/sts/label_keys/requester.h>
#include <solomon/services/memstore/api/memstore_service.pb.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NDataProxy;
using namespace yandex::monitoring::memstore;

TEST(TLabelKeysRequesterTest, ToMemStoreRequest) {
    TLabelKeysQuery query;
    query.Project = "solomon";
    query.Selectors = ParseSelectors("{service=fetcher, sensor=cpu_usage, cluster=testing}");
    query.Deadline = TDuration::Seconds(30).ToDeadLine();
    query.Time = TTimeRange{
            .From = TInstant::ParseIso8601("2021-02-03T04:05:06"),
            .To = TInstant::ParseIso8601("2021-02-03T05:06:07")};
    query.Producer = yandex::solomon::common::RequestProducer::STAFF;

    auto req = ToMemStoreRequest(query);
    EXPECT_EQ(req.num_id(), 0u); // num_id must not be filled
    EXPECT_EQ(req.selectors(), "{'sensor' == 'cpu_usage'}"); // PCS were removed
    EXPECT_EQ(req.from_millis(), query.Time.From.MilliSeconds());
    EXPECT_EQ(req.to_millis(), query.Time.To.MilliSeconds());
}
