#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>
#include <solomon/services/dataproxy/lib/cluster_id/replica_map.h>
#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/shard/shard_id.h>
#include <solomon/services/dataproxy/lib/shard/shard_key.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>
#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

#include <grpc++/support/status_code_enum.h>

namespace yandex::monitoring::memstore {
class LabelValuesResponse;
} // namespace yandex::monitoring::memstore

namespace NSolomon::NDataProxy {

class TLabelValuesMerger {
public:
    TLabelValuesMerger(size_t limit, TString project, bool removeNonYasmLabels) noexcept
        : Limit_{limit}
        , Project_{std::move(project)}
        , RemoveNonYasmLabels_{removeNonYasmLabels}
    {
    }

    void AddResponse(TClusterId clusterId, const yandex::monitoring::memstore::LabelValuesResponse& resp);

    void AddError(TClusterId clusterId, TShardId shardId, grpc::StatusCode statusCode, TString message);

    std::unique_ptr<TLabelValuesResult> Finish();

private:
    struct TLabelState {
        absl::flat_hash_set<ui32> Values;
        TReplicaMap<ui32> MetricCount;
        TReplicaMap<bool> Truncated;
    };

    size_t Limit_;
    TString Project_;
    bool RemoveNonYasmLabels_;
    NStringPool::TStringPoolBuilder Strings_;
    absl::flat_hash_map<ui32, TLabelState> Labels_; // label key -> label state
    TDataSourceErrors Errors_;
    TReplicaMap<ui32> MetricCount_;
};

} // namespace NSolomon::NDataProxy
