#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>
#include <solomon/services/dataproxy/lib/cluster_id/replica_map.h>
#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/shard/shard_id.h>
#include <solomon/services/dataproxy/lib/shard/shard_key.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>
#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

#include <grpc++/support/status_code_enum.h>

namespace yandex::monitoring::memstore {
class ReadManyResponse;
} // namespace yandex::monitoring::memstore

namespace NSolomon::NDataProxy {

class TReadManyMerger {
    struct TMetricData: private TMoveOnly {
        TReplicaMap<NMonitoring::EMetricType> Types{NMonitoring::EMetricType::UNKNOWN};
        TReplicaMap<std::unique_ptr<ITimeSeries>> TimeSeries;
    };

public:
    explicit TReadManyMerger(size_t limit, TString project) noexcept
        : Limit_{limit}
        , Project_(std::move(project))
    {
    }

    void AddResponse(TClusterId clusterId, const TShardSubKey& shardKey, const yandex::monitoring::memstore::ReadManyResponse& resp);

    void AddError(TClusterId clusterId, TShardId shardId, grpc::StatusCode statusCode, TString message);

    std::unique_ptr<TReadManyResult> Finish();

private:
    static std::unique_ptr<ITimeSeries> Merge(TMetricData& data);

private:
    size_t Limit_;
    TString Project_;
    absl::flat_hash_map<TMetricKey<ui32>, TMetricData> Metrics_;
    NStringPool::TStringPoolBuilder Strings_;
    TDataSourceErrors Errors_;
};

} // namespace NSolomon::NDataProxy
