#include "merger.h"

#include <solomon/services/memstore/api/memstore_service.pb.h>

#include <solomon/libs/cpp/proto_convert/metric_type.h>

namespace NSolomon::NDataProxy {

using yandex::monitoring::memstore::UniqueLabelsResponse;

void TUniqueLabelsMerger::AddResponse(const UniqueLabelsResponse& resp) {
    NStringPool::TStringPool respPool{resp.string_pool()};

    if (Labels_.empty()) {
        Labels_.reserve(resp.labels_size());
    }

    for (const auto& labelsProto: resp.labels()) {
        int size = labelsProto.labels_idx_size();
        Y_ENSURE(size % 2 == 0, "labels with non even number of items: " << size);

        TLabels<ui32> labels;
        labels.reserve(labelsProto.labels_idx_size());
        for (int i = 0; i < size; ) {
            TStringBuf key = respPool[labelsProto.labels_idx(i++)];
            TStringBuf value = respPool[labelsProto.labels_idx(i++)];
            labels.emplace_back(Strings_.Put(key), Strings_.Put(value));
        }
        Labels_.emplace(std::move(labels));
    }
}

void TUniqueLabelsMerger::AddError(TClusterId clusterId, TShardId shardId, grpc::StatusCode statusCode, TString message) {
    Y_UNUSED(clusterId, shardId, statusCode, message);
    // TODO: aggregate per shard errors
    Errors_.emplace_back(statusCode, std::move(message));
}

std::unique_ptr<TUniqueLabelsResult> TUniqueLabelsMerger::Finish() {
    auto result = std::make_unique<TUniqueLabelsResult>();
    result->Strings = std::move(Strings_);
    result->Labels = TVector<TLabels<ui32>>{std::begin(Labels_), std::end(Labels_)};
    result->Errors = std::move(Errors_);
    return result;
}

} // namespace NSolomon::NDataProxy
