#include <solomon/services/dataproxy/lib/datasource/sts/unique_labels/requester.h>
#include <solomon/services/memstore/api/memstore_service.pb.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NDataProxy;
using namespace yandex::monitoring::memstore;

TEST(TLabelKeysRequesterTest, ToMemStoreRequest) {
    TUniqueLabelsQuery query;
    query.Project = "solomon";
    query.Selectors = ParseSelectors("{service=fetcher, signal=cpu_usage, cluster=testing}");
    query.Keys = {"host", "ctype", "prj"};
    query.Deadline = TDuration::Seconds(30).ToDeadLine();
    query.Time = TTimeRange{
            .From = TInstant::ParseIso8601("2021-02-03T04:05:06"),
            .To = TInstant::ParseIso8601("2021-02-03T05:06:07")};
    query.Producer = yandex::solomon::common::RequestProducer::STAFF;

    auto req = ToMemStoreRequest(query);
    EXPECT_EQ(req.num_id(), 0u); // num_id must not be filled
    EXPECT_EQ(req.selectors(), "{'signal' == 'cpu_usage'}"); // PCS were removed

    ASSERT_EQ(req.keys_size(), 3);
    EXPECT_EQ(req.keys(0), "host");
    EXPECT_EQ(req.keys(1), "ctype");
    EXPECT_EQ(req.keys(2), "prj");

    EXPECT_EQ(req.from_millis(), query.Time.From.MilliSeconds());
    EXPECT_EQ(req.to_millis(), query.Time.To.MilliSeconds());
}
