#pragma once

#include <solomon/services/dataproxy/lib/datasource/datasource.h>
#include <solomon/services/dataproxy/lib/datasource/result_handler.h>

namespace NSolomon::NDataProxy {

inline std::optional<yandex::solomon::math::OperationTop> GetTopOperation(const TReadManyQuery& query) {
    for (size_t i = 0; i < query.Operations.size(); ++i) {
        if (query.Operations[i].has_top()) {
            return query.Operations[i].top();
        }
    }
    return std::nullopt;
}

IResultHandlerPtr<TReadManyResult> MakeTopHandler(IResultHandlerPtr<TReadManyResult> originalHandler, yandex::solomon::math::OperationTop operationTop);

}
