#include <solomon/services/dataproxy/lib/datasource/ut_utils.h>
#include <solomon/services/dataproxy/lib/datasource/top/top.h>

using namespace NSolomon;
using namespace NSolomon::NDataProxy;

TEST(Top, Simple) {
    auto [sourceMetrics, sourceStrPool] = MakeMetricsWithTimeseries<double, true>(
            {
                {
                    {
                          {"signal", "counter-instance1_tmmv"},
                          {"host", "host1"},
                    },
                    {1, 2, 3, 4, 5, 6},
                    NMonitoring::EMetricType::GAUGE
                },
                {
                    {
                          {"signal", "counter-instance2_tmmv"},
                          {"host", "host1"},
                    },
                    {1, 2, 3, 4, 5, 6, 7},
                    NMonitoring::EMetricType::GAUGE
                },
                {
                    {
                          {"signal", "counter-instance1_tmmv"},
                          {"host", "host2"},
                    },
                    {1, 2, 3, 4, 5, 6, 7, 8},
                    NMonitoring::EMetricType::GAUGE
                },
                {
                    {
                            {"signal", "counter-instance2_tmmv"},
                            {"host", "host2"},
                    },
                    {1, 2, 3, 4, 5, 6, 7, 8, 9},
                    NMonitoring::EMetricType::GAUGE
                }
            },
            NZoom::NAccumulators::EAccumulatorType::Summ);
    
    auto [expectedMetrics, expectedStrPool] = MakeMetricsWithTimeseries<double, true>(
            {
                {
                    {
                          {"signal", "counter-instance1_tmmv"},
                          {"host", "host2"},
                    },
                    {1, 2, 3, 4, 5, 6, 7, 8},
                    NMonitoring::EMetricType::GAUGE
                },
                {
                    {
                            {"signal", "counter-instance2_tmmv"},
                            {"host", "host2"},
                    },
                    {1, 2, 3, 4, 5, 6, 7, 8, 9},
                    NMonitoring::EMetricType::GAUGE
                }
            },
            NZoom::NAccumulators::EAccumulatorType::Summ);

    std::unique_ptr<TReadManyResult> sourceReadManyResult = std::make_unique<TReadManyResult>();
    sourceReadManyResult->Metrics = std::move(sourceMetrics);
    sourceReadManyResult->Strings = std::move(sourceStrPool);

    std::unique_ptr<TReadManyResult> expectedReadManyResult = std::make_unique<TReadManyResult>();
    expectedReadManyResult->Metrics = std::move(expectedMetrics);
    expectedReadManyResult->Strings = std::move(expectedStrPool);

    auto handlerMock = MakeIntrusive<TReadManyResultHandlerMock>();
    EXPECT_CALL(*handlerMock, OnSuccess(ReadManyResultEq(expectedReadManyResult.get()))).Times(1);

    yandex::solomon::math::OperationTop top;
    top.set_asc(false);
    top.set_limit(2);
    top.set_time_aggregation(yandex::solomon::math::Aggregation::AVG);

    auto handlerTop = MakeTopHandler(std::move(handlerMock), std::move(top));
    handlerTop->OnSuccess(std::move(sourceReadManyResult));
}
