#pragma once

#include "placement_config.h"

#include <solomon/services/dataproxy/lib/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/clients/tsdb/rpc.h>
#include <solomon/libs/cpp/string_map/string_map.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon::NDataProxy {

class TPlacementActorEvents: private TEventSlot<EEventSpace::DataProxy, ES_TSDB_PLACEMENT> {
    enum {
        ResolveHosts = SpaceBegin,
        ResolveHostsResponse,
        ResolveGroups,
        ResolveGroupsResponse,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TResolveHosts: public ::NActors::TEventLocal<TResolveHosts, ResolveHosts> {
        TVector<TString> UserHosts;

        explicit TResolveHosts(TVector<TString> hosts)
            : UserHosts{std::move(hosts)}
        {
        }
    };

    struct TResolveHostsResponse: NActors::TEventLocal<TResolveHostsResponse, ResolveHostsResponse> {
        TStringMap<absl::flat_hash_set<TString>> UserHostToGroups;

        explicit TResolveHostsResponse(TStringMap<absl::flat_hash_set<TString>> userHostToGroups)
            : UserHostToGroups{std::move(userHostToGroups)}
        {
        }
    };

    struct TResolveGroups: public ::NActors::TEventLocal<TResolveGroups, ResolveGroups> {
        TVector<TString> Groups;

        explicit TResolveGroups(TVector<TString> groups)
            : Groups{std::move(groups)}
        {
        }
    };

    struct TResolveGroupsResponse: NActors::TEventLocal<TResolveGroupsResponse, ResolveGroupsResponse> {
        TStringMap<absl::flat_hash_set<TString>> GroupToHosts;

        explicit TResolveGroupsResponse(TStringMap<absl::flat_hash_set<TString>> groupToHosts)
            : GroupToHosts{std::move(groupToHosts)}
        {
        }
    };
};

std::unique_ptr<NActors::IActor> PlacementActor(
        std::shared_ptr<const TYasmGroupToTsdbHosts> groupToHosts,
        std::shared_ptr<NSolomon::NTsdb::ITsdbClusterRpc> tsdbCluster,
        TString fsCachePath,
        TDuration fsCacheLifetime);

} // namespace NSolomon::NDataProxy
