#pragma once

#include <solomon/libs/cpp/string_map/string_map.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NSolomon::NDataProxy {

using TYasmGroupToTsdbHosts = TStringMap<TVector<TString>>;
using TUserHostToGroups = TStringMap<TVector<TString>>;

std::shared_ptr<TYasmGroupToTsdbHosts> ParseGroupPlacementFile(const TString& filePath);
std::shared_ptr<TUserHostToGroups> ParseUserHostsPlacementFile(const TString& filePath, TDuration cacheLifetime);

} // namespace NSolomon::NDataProxy
