#pragma once

#include "placement_config.h"

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/result_handler.h>

#include <solomon/libs/cpp/clients/tsdb/rpc.h>
#include <solomon/libs/cpp/string_map/string_map.h>
#include <solomon/libs/cpp/trace/trace.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

namespace NSolomon::NDataProxy {

std::unique_ptr<NActors::IActor> ReadManyActor(
    std::shared_ptr<const TYasmGroupToTsdbHosts> groupToHosts,
    NActors::TActorId placementActor,
    std::shared_ptr<NSolomon::NTsdb::ITsdbClusterRpc> tsdbCluster,
    TReadManyQuery query,
    IResultHandlerPtr<TReadManyResult> handler,
    NMonitoring::TMetricRegistry& registry,
    NTracing::TSpanId traceCtx);

} // namespace NSolomon::NDataProxy
