#pragma once

#include "placement_config.h"

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>
#include <solomon/libs/cpp/clients/tsdb/rpc.h>
#include <solomon/libs/cpp/string_map/string_map.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>
#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/string.h>

namespace NSolomon::NDataProxy {

class IDataSource;
class TTsdbSourceConfig;
class TClusterMap;

TIntrusivePtr<IDataSource> TsdbSource(
        TActorRuntime& runtime,
        std::shared_ptr<const TYasmGroupToTsdbHosts> groupToHosts,
        std::shared_ptr<NSolomon::NTsdb::ITsdbClusterRpc> tsdbCluster,
        NActors::TActorId placement,
        NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NDataProxy
