#include "cluster_name.h"

#include <library/cpp/consistent_hashing/consistent_hashing.h>
#include <util/string/cast.h>

namespace NSolomon::NDataProxy {

constexpr size_t MAX_DIGITS = std::numeric_limits<ui16>::digits10;
constexpr TStringBuf HOST = "host_";
constexpr TStringBuf GROUP = "group_";

TString GetClusterName(TStringBuf host, TStringBuf signal, ui64 shardCount) {
    TString result;
    result.reserve(GROUP.size() + MAX_DIGITS);

    ui64 hashValue;
    if (!host) {
        result.append(GROUP);
        hashValue = CityHash64(signal.data(), signal.size());
    } else {
        result.append(HOST);
        hashValue = CombineHashes(CityHash64(host.data(), host.size()), CityHash64(signal.data(), signal.size()));
    }

    ui16 num = static_cast<ui16>(ConsistentHashing(hashValue, shardCount));

    // doing result.append(ToString(num)), but without additional allocation and copy
    size_t prevSize = result.size();
    result.resize(prevSize + MAX_DIGITS);
    const auto strLen = ToStringImpl<ui16>(num, result.begin() + prevSize, MAX_DIGITS);
    result.resize(prevSize + strLen);

    return result;
}

} // namespace NSolomon::NDataProxy
